//---------------------------------------------------------
// SIXCA DAQ Example
// Free for personal and comercial use
//
// www.sixca.com
//
// Protocol (ASCII Mode)
//---------------------------------------------------------
//   Command                     PC Send         PIC Send
//---------------------------------------------------------
//
// Set digital output bit      *ANS#13              -
// Read digital input port     *B#13             *BXX#13
// Read Analog channel         *CN#13            *CNXXX#13
//
// When : * = Header
//        X = Ascii hex ('0'-'9','A'-'F')
//        N = Bit or channel ('0'-'7')
//      #13 = End of protocol
//
//---------------------------------------------------------

unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CPort, ExtCtrls, Buttons, CPortCtl, A3nalogGauge,FmtBcd;

type
  TForm1 = class(TForm)
    ComPort1: TComPort;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    out8: TCheckBox;
    out7: TCheckBox;
    out6: TCheckBox;
    out5: TCheckBox;
    out4: TCheckBox;
    out3: TCheckBox;
    out2: TCheckBox;
    out1: TCheckBox;
    CheckBox8: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    CheckBox12: TCheckBox;
    CheckBox13: TCheckBox;
    CheckBox14: TCheckBox;
    CheckBox15: TCheckBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Timer1: TTimer;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label9: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Edit1: TEdit;
    GroupBox3: TGroupBox;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    BitBtn5: TBitBtn;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure out8Click(Sender: TObject);
    procedure out7Click(Sender: TObject);
    procedure out6Click(Sender: TObject);
    procedure out5Click(Sender: TObject);
    procedure out4Click(Sender: TObject);
    procedure out3Click(Sender: TObject);
    procedure out2Click(Sender: TObject);
    procedure out1Click(Sender: TObject);
    procedure ComPort1RxChar(Sender: TObject; Count: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
  private
  Input_buffer:array[0..64] of byte;

  tmSt:integer;
  DigitalInp,ADCch:byte;

  procedure ChangeCheckBox;
  procedure CalculateADC(ch:byte);
  procedure CheckCMD;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}

procedure TForm1.CheckCMD;
begin
        case input_buffer[1] of
        ord('B'): begin
                    DigitalInp:=(input_buffer[2] and $0F) or ((input_buffer[3] and $0F) shl 4);
                    ChangeCheckBox;
                  end;
        ord('C'): begin
                    ADCCh:=input_buffer[2] and $0F;
                    CalculateADC(ADCCh);
                  end;
        end;
end;

procedure TForm1.CalculateADC(ch:byte);
var ADCRes:word;
    Volt:Double;
begin
        ADCRes:=StrToInt(chr(Input_buffer[6])+chr(Input_buffer[5])+chr(Input_buffer[4])+chr(Input_buffer[3]));
        Volt:=(5*ADCRes)/$3FF;

        if (ch=0) then
         Label25.caption:=FloatToStrF(Volt,ffFixed,3,2)+' V'
        else
        if (ch=1) then
         Label26.caption:=FloatToStrF(Volt,ffFixed,3,2)+' V'
        else
        if (ch=2) then
         Label27.caption:=FloatToStrF(Volt,ffFixed,3,2)+' V'
        else
        if (ch=3) then
         Label28.caption:=FloatToStrF(Volt,ffFixed,3,2)+' V'
        else
        if (ch=4) then
         Label29.caption:=FloatToStrF(Volt,ffFixed,3,2)+' V'
        else
        if (ch=5) then
         Label30.caption:=FloatToStrF(Volt,ffFixed,3,2)+' V'
        else
        if (ch=6) then
         Label31.caption:=FloatToStrF(Volt,ffFixed,3,2)+' V'
        else
        if (ch=7) then
         Label32.caption:=FloatToStrF(Volt,ffFixed,3,2)+' V'
end;

procedure TForm1.ChangeCheckBox;
begin

      Edit1.Text:=IntToHex(DigitalInp,2);
      if ((DigitalInp and $01) = 1) then
          CheckBox15.Checked:=true
      else
          CheckBox15.Checked:=false;

      if ((DigitalInp and $02) = $02) then
          CheckBox14.Checked:=true
      else
          CheckBox14.Checked:=false;

      if ((DigitalInp and $04) = $04) then
          CheckBox13.Checked:=true
      else
          CheckBox13.Checked:=false;

      if ((DigitalInp and $08) = $08) then
          CheckBox12.Checked:=true
      else
          CheckBox12.Checked:=false;

      if ((DigitalInp and $10) = $10) then
          CheckBox11.Checked:=true
      else
          CheckBox11.Checked:=false;

      if ((DigitalInp and $20) = $20) then
          CheckBox10.Checked:=true
      else
          CheckBox10.Checked:=false;

      if ((DigitalInp and $40) = $40) then
          CheckBox9.Checked:=true
      else
          CheckBox9.Checked:=false;

      if ((DigitalInp and $80) = $80) then
          CheckBox8.Checked:=true
      else
          CheckBox8.Checked:=false;
end;




procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
        comport1.Close;
end;

procedure TForm1.out8Click(Sender: TObject);
begin
        if (out8.Checked) then
         Comport1.WriteStr('*A71'+#13)
        else
         Comport1.WriteStr('*A70'+#13);
end;

procedure TForm1.out7Click(Sender: TObject);
begin
        if (out7.Checked) then
         Comport1.WriteStr('*A61'+#13)
        else
         Comport1.WriteStr('*A60'+#13);
end;

procedure TForm1.out6Click(Sender: TObject);
begin
        if (out6.Checked) then
         Comport1.WriteStr('*A51'+#13)
        else
         Comport1.WriteStr('*A50'+#13);
end;

procedure TForm1.out5Click(Sender: TObject);
begin
        if (out5.Checked) then
         Comport1.WriteStr('*A41'+#13)
        else
         Comport1.WriteStr('*A40'+#13);
end;

procedure TForm1.out4Click(Sender: TObject);
begin
        if (out4.Checked) then
         Comport1.WriteStr('*A31'+#13)
        else
         Comport1.WriteStr('*A30'+#13);
end;

procedure TForm1.out3Click(Sender: TObject);
begin
        if (out3.Checked) then
         Comport1.WriteStr('*A21'+#13)
        else
         Comport1.WriteStr('*A20'+#13);
end;

procedure TForm1.out2Click(Sender: TObject);
begin
        if (out2.Checked) then
         Comport1.WriteStr('*A11'+#13)
        else
         Comport1.WriteStr('*A10'+#13);
end;

procedure TForm1.out1Click(Sender: TObject);
begin
        if (out1.Checked) then
         Comport1.WriteStr('*A01'+#13)
        else
         Comport1.WriteStr('*A00'+#13);
end;

procedure TForm1.ComPort1RxChar(Sender: TObject; Count: Integer);
begin

        Comport1.Read(Input_buffer,count);
        if ((Input_buffer[0]=ord('*')) and (Input_buffer[count-1]=ord(#13))) then
        begin
           checkCMD;
        end;

end;

procedure TForm1.Timer1Timer(Sender: TObject);
var St:string;
begin

        if ((tmSt=0) or (tmSt<8)) then
        begin
           St:='*C'+inttostr(tmSt)+#13;
           Comport1.WriteStr(St);
           tmSt:=tmSt+1;
        end
        else
        begin
           Comport1.WriteStr('*B'+#13);
           tmSt:=0;
        end;

        
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var Answer:string;
begin
        comport1.Open;
        comport1.WriteStr('*B'+#13);
        sleep(10);
        ComPort1.ReadStr(Answer, ComPort1.InputCount);

        if not (Pos('*B', Answer) > 0) then
        begin
            label35.Font.Color:=clRed;
            label35.caption:='Hardware NOT found on : ' + ComPort1.Port;
            comport1.Close;
            exit;
        end
        else
        begin
            label35.Font.Color:=clBlack;
            label35.caption:='Hardware connected on : ' + ComPort1.Port;
            timer1.Enabled:=true;
            bitbtn1.Enabled:=false;
            bitbtn5.Enabled:=false;
            bitbtn2.Enabled:=true;
        end;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
        Comport1.WriteStr('*A00'+#13);
        Comport1.WriteStr('*A10'+#13);
        Comport1.WriteStr('*A20'+#13);
        Comport1.WriteStr('*A30'+#13);
        Comport1.WriteStr('*A40'+#13);
        Comport1.WriteStr('*A50'+#13);
        Comport1.WriteStr('*A60'+#13);
        Comport1.WriteStr('*A70'+#13);
        out1.Checked:=false;
        out2.Checked:=false;
        out3.Checked:=false;
        out4.Checked:=false;
        out5.Checked:=false;
        out6.Checked:=false;
        out7.Checked:=false;
        out8.Checked:=false;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
        Comport1.WriteStr('*A01'+#13);
        Comport1.WriteStr('*A11'+#13);
        Comport1.WriteStr('*A21'+#13);
        Comport1.WriteStr('*A31'+#13);
        Comport1.WriteStr('*A41'+#13);
        Comport1.WriteStr('*A51'+#13);
        Comport1.WriteStr('*A61'+#13);
        Comport1.WriteStr('*A71'+#13);
        out1.Checked:=true;
        out2.Checked:=true;
        out3.Checked:=true;
        out4.Checked:=true;
        out5.Checked:=true;
        out6.Checked:=true;
        out7.Checked:=true;
        out8.Checked:=true;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
        bitbtn1.Enabled:=true;
        bitbtn2.Enabled:=false;
        bitbtn5.Enabled:=true;
        timer1.Enabled:=false;
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
        Comport1.ShowSetupDialog;
end;

end.
